/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.HtmlResponseStateManager;
import org.apache.myfaces.renderkit.html.HtmlResponseWriterImpl;

public class HtmlRenderKitImpl
extends RenderKit {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl == null ? (class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl = HtmlRenderKitImpl.class$("org.apache.myfaces.renderkit.html.HtmlRenderKitImpl")) : class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl));
    private static String HTML_CONTENT_TYPE = "text/html";
    private static String XHTML_CONTENT_TYPE = "application/xhtml+xml";
    private static String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static String TEXT_XML_CONTENT_TYPE = "text/xml";
    private static String DEFAULT_CHAR_ENCODING = "ISO-8859-1";
    private Map _renderers = new HashMap();
    private ResponseStateManager _responseStateManager = new HtmlResponseStateManager();
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlRenderKitImpl;

    private String key(String componentFamily, String rendererType) {
        return componentFamily + "." + rendererType;
    }

    public Renderer getRenderer(String componentFamily, String rendererType) {
        Renderer renderer = (Renderer)this._renderers.get(this.key(componentFamily, rendererType));
        if (renderer == null) {
            log.warn((Object)("Unsupported component-family/renderer-type: " + componentFamily + "/" + rendererType));
        }
        return renderer;
    }

    public void addRenderer(String componentFamily, String rendererType, Renderer renderer) {
        this._renderers.put(this.key(componentFamily, rendererType), renderer);
    }

    public ResponseStateManager getResponseStateManager() {
        return this._responseStateManager;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeListString, String characterEncoding) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (contentTypeListString == null && (contentTypeListString = (String)context.getExternalContext().getRequestHeaderMap().get("Accept")) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No content type list given, creating HtmlResponseWriterImpl with default content type.");
            }
            contentTypeListString = HTML_CONTENT_TYPE;
        }
        List contentTypeList = this.splitContentTypeListString(contentTypeListString);
        String[] supportedContentTypeArray = new String[]{HTML_CONTENT_TYPE, XHTML_CONTENT_TYPE, APPLICATION_XML_CONTENT_TYPE, TEXT_XML_CONTENT_TYPE};
        String selectedContentType = null;
        for (int i = 0; i < contentTypeList.size(); ++i) {
            String contentType = (String)contentTypeList.get(i);
            for (int j = 0; j < supportedContentTypeArray.length; ++j) {
                String supportedContentType = supportedContentTypeArray[j].trim();
                if (contentType.indexOf(supportedContentType) == -1) continue;
                if (contentType.indexOf(HTML_CONTENT_TYPE) != -1) {
                    selectedContentType = HTML_CONTENT_TYPE;
                    break;
                }
                if (contentType.indexOf(XHTML_CONTENT_TYPE) == -1 && contentType.indexOf(APPLICATION_XML_CONTENT_TYPE) == -1 && contentType.indexOf(TEXT_XML_CONTENT_TYPE) == -1) break;
                selectedContentType = XHTML_CONTENT_TYPE;
                break;
            }
            if (selectedContentType != null) break;
        }
        if (selectedContentType == null) {
            throw new IllegalArgumentException("ContentTypeList does not contain a supported content type: " + contentTypeListString);
        }
        if (characterEncoding == null) {
            characterEncoding = DEFAULT_CHAR_ENCODING;
        }
        return new HtmlResponseWriterImpl(writer, selectedContentType, characterEncoding);
    }

    private List splitContentTypeListString(String contentTypeListString) {
        ArrayList<String> contentTypeList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(contentTypeListString, ",");
        while (st.hasMoreTokens()) {
            String contentType = st.nextToken().trim();
            int semicolonIndex = contentType.indexOf(";");
            if (semicolonIndex != -1) {
                contentType = contentType.substring(0, semicolonIndex);
            }
            contentTypeList.add(contentType);
        }
        return contentTypeList;
    }

    public ResponseStream createResponseStream(OutputStream outputstream) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " UnsupportedOperationException");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

