/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.util.DummyFormResponseWriter;
import org.apache.myfaces.renderkit.html.util.DummyFormUtils;
import org.apache.myfaces.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.renderkit.html.util.UnicodeEncoder;

public class HtmlResponseWriterImpl
extends ResponseWriter
implements DummyFormResponseWriter {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$HtmlResponseWriterImpl == null ? (class$org$apache$myfaces$renderkit$html$HtmlResponseWriterImpl = HtmlResponseWriterImpl.class$("org.apache.myfaces.renderkit.html.HtmlResponseWriterImpl")) : class$org$apache$myfaces$renderkit$html$HtmlResponseWriterImpl));
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private boolean _writeDummyForm = false;
    private Set _dummyFormParams = null;
    private Writer _writer;
    private String _contentType;
    private String _characterEncoding;
    private String _startElementName;
    private UIComponent _startElementUIComponent;
    private boolean _startTagOpen;
    private static final Set s_emptyHtmlElements = new HashSet();
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlResponseWriterImpl;

    public HtmlResponseWriterImpl(Writer writer, String contentType, String characterEncoding) {
        this._writer = writer;
        this._contentType = contentType;
        if (this._contentType == null) {
            if (log.isInfoEnabled()) {
                log.debug((Object)"No content type given, using default content type text/html");
            }
            this._contentType = DEFAULT_CONTENT_TYPE;
        }
        this._characterEncoding = characterEncoding;
        if (this._characterEncoding == null) {
            if (log.isInfoEnabled()) {
                log.debug((Object)"No character encoding given, using default character encoding ISO-8859-1");
            }
            this._characterEncoding = DEFAULT_CHARACTER_ENCODING;
        }
    }

    public static boolean supportsContentType(String contentType) {
        return true;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void flush() throws IOException {
        this.closeStartTagIfNecessary();
    }

    public void startDocument() {
    }

    public void endDocument() throws IOException {
        FacesContext facesContext;
        MyfacesConfig myfacesConfig;
        this.flush();
        if (this._writeDummyForm) {
            DummyFormUtils.writeDummyForm(this, this._dummyFormParams);
        }
        if ((myfacesConfig = MyfacesConfig.getCurrentInstance((facesContext = FacesContext.getCurrentInstance()).getExternalContext())).isDetectJavascript() && !JavascriptUtils.isJavascriptDetected(facesContext.getExternalContext())) {
            this.write("<script type=\"text/javascript\">\n<!--\ndocument.location.replace('" + facesContext.getApplication().getViewHandler().getResourceURL(facesContext, "/_javascriptDetector_") + "?goto=" + facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId()) + "');\n//-->\n</script>");
        }
        if (myfacesConfig.isAutoScroll()) {
            JavascriptUtils.renderAutoScrollFunction(facesContext, this);
        }
        this._writer.flush();
    }

    public void startElement(String name, UIComponent uiComponent) throws IOException {
        if (name == null) {
            throw new NullPointerException("elementName name must not be null");
        }
        this.closeStartTagIfNecessary();
        this._writer.write(60);
        this._writer.write(name);
        this._startElementName = name;
        this._startElementUIComponent = uiComponent;
        this._startTagOpen = true;
    }

    private void closeStartTagIfNecessary() throws IOException {
        if (this._startTagOpen) {
            if (s_emptyHtmlElements.contains(this._startElementName.toLowerCase())) {
                this._writer.write("/>");
                this._startElementName = null;
            } else {
                this._writer.write(62);
            }
            this._startTagOpen = false;
        }
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("elementName name must not be null");
        }
        if (log.isWarnEnabled() && this._startElementName != null && !name.equals(this._startElementName) && log.isWarnEnabled()) {
            log.warn((Object)("HTML nesting warning on closing " + name + ": element " + this._startElementName + (this._startElementUIComponent == null ? "" : " rendered by component : " + RendererUtils.getPathToComponent(this._startElementUIComponent)) + " not explicitly closed"));
        }
        if (this._startTagOpen) {
            if (s_emptyHtmlElements.contains(name.toLowerCase())) {
                this._writer.write("/>");
            } else {
                this._writer.write("></");
                this._writer.write(name);
                this._writer.write(62);
            }
            this._startTagOpen = false;
        } else if (s_emptyHtmlElements.contains(name.toLowerCase())) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("HTML nesting warning on closing " + name + ": This element must not contain nested elements or text in HTML"));
            }
        } else {
            this._writer.write("</");
            this._writer.write(name);
            this._writer.write(62);
        }
        this._startElementName = null;
        this._startElementUIComponent = null;
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException("attributeName name must not be null");
        }
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                this._writer.write(32);
                this._writer.write(name);
                this._writer.write("=\"");
                this._writer.write(name);
                this._writer.write(34);
            }
        } else {
            String strValue = value.toString();
            this._writer.write(32);
            this._writer.write(name);
            this._writer.write("=\"");
            this._writer.write(HTMLEncoder.encode(strValue, false, false));
            this._writer.write(34);
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException("attributeName name must not be null");
        }
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        String strValue = value.toString();
        this._writer.write(32);
        this._writer.write(name);
        this._writer.write("=\"");
        if (strValue.toLowerCase().startsWith("javascript:")) {
            this._writer.write(HTMLEncoder.encode(strValue, false, false));
        } else {
            this._writer.write(strValue);
        }
        this._writer.write(34);
    }

    public void writeComment(Object value) throws IOException {
        if (value == null) {
            throw new NullPointerException("comment name must not be null");
        }
        this.closeStartTagIfNecessary();
        this._writer.write("<!--");
        this._writer.write(value.toString());
        this._writer.write("-->");
    }

    public void writeText(Object value, String componentPropertyName) throws IOException {
        if (value == null) {
            throw new NullPointerException("text name must not be null");
        }
        this.closeStartTagIfNecessary();
        if (value == null) {
            return;
        }
        String strValue = value.toString();
        if (this.isScriptOrStyle()) {
            this._writer.write(UnicodeEncoder.encode(strValue, false, false));
        } else {
            this._writer.write(HTMLEncoder.encode(strValue, false, false));
        }
    }

    public void writeText(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException("cbuf name must not be null");
        }
        if (cbuf.length < off + len) {
            throw new IndexOutOfBoundsException(off + len + " > " + cbuf.length);
        }
        this.closeStartTagIfNecessary();
        if (this.isScriptOrStyle()) {
            String strValue = new String(cbuf, off, len);
            this._writer.write(UnicodeEncoder.encode(strValue, false, false));
        } else if (this.isTextarea()) {
            String strValue = new String(cbuf, off, len);
            this._writer.write(HTMLEncoder.encode(strValue, false, false));
        } else {
            String strValue = new String(cbuf, off, len);
            this._writer.write(HTMLEncoder.encode(strValue, true, true));
        }
    }

    private boolean isScriptOrStyle() {
        return this._startElementName != null && (this._startElementName.equalsIgnoreCase("script") || this._startElementName.equalsIgnoreCase("style"));
    }

    private boolean isTextarea() {
        return this._startElementName != null && this._startElementName.equalsIgnoreCase("textarea");
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        HtmlResponseWriterImpl newWriter = new HtmlResponseWriterImpl(writer, this.getContentType(), this.getCharacterEncoding());
        newWriter._writeDummyForm = this._writeDummyForm;
        newWriter._dummyFormParams = this._dummyFormParams;
        return newWriter;
    }

    public void close() throws IOException {
        if (this._startTagOpen) {
            this._writer.write(" />");
        }
        this._writer.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = new String(cbuf, off, len);
        this._writer.write(UnicodeEncoder.encode(strValue, false, false));
    }

    public void write(int c) throws IOException {
        this.closeStartTagIfNecessary();
        this._writer.write(c);
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = new String(cbuf);
        this._writer.write(UnicodeEncoder.encode(strValue, false, false));
    }

    public void write(String str) throws IOException {
        this.closeStartTagIfNecessary();
        if (str.length() > 0) {
            this._writer.write(UnicodeEncoder.encode(str, false, false));
        }
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = str.substring(off, off + len);
        this._writer.write(UnicodeEncoder.encode(strValue, false, false));
    }

    public boolean isWriteDummyForm() {
        return this._writeDummyForm;
    }

    public void setWriteDummyForm(boolean writeDummyForm) {
        this._writeDummyForm = writeDummyForm;
    }

    public String getDummyFormName() {
        return "linkDummyForm";
    }

    public void addDummyFormParameter(String paramName) {
        if (this._dummyFormParams == null) {
            this._dummyFormParams = new HashSet();
        }
        this._dummyFormParams.add(paramName);
    }

    public Set getDummyFormParams() {
        return this._dummyFormParams;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_emptyHtmlElements.add("area");
        s_emptyHtmlElements.add("br");
        s_emptyHtmlElements.add("base");
        s_emptyHtmlElements.add("basefont");
        s_emptyHtmlElements.add("col");
        s_emptyHtmlElements.add("frame");
        s_emptyHtmlElements.add("hr");
        s_emptyHtmlElements.add("img");
        s_emptyHtmlElements.add("input");
        s_emptyHtmlElements.add("isindex");
        s_emptyHtmlElements.add("link");
        s_emptyHtmlElements.add("meta");
        s_emptyHtmlElements.add("param");
    }
}

