/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.util.ArrayUtils;
import org.apache.myfaces.util.StringUtils;

public class HtmlTableRendererBase
extends HtmlRenderer {
    protected static final String HEADER_FACET_NAME = "header";
    protected static final String FOOTER_FACET_NAME = "footer";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$HtmlTableRendererBase == null ? (class$org$apache$myfaces$renderkit$html$HtmlTableRendererBase = HtmlTableRendererBase.class$("org.apache.myfaces.renderkit.html.HtmlTableRendererBase")) : class$org$apache$myfaces$renderkit$html$HtmlTableRendererBase));
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlTableRendererBase;
    static /* synthetic */ Class class$javax$faces$component$UIData;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlTableRendererBase.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.beforeTable(facesContext, (UIData)uiComponent);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("table", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        this.renderFacet(facesContext, writer, (UIComponent)((UIData)uiComponent), true);
        this.renderFacet(facesContext, writer, (UIComponent)((UIData)uiComponent), false);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlTableRendererBase.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tbody", component);
        writer.writeAttribute("id", (Object)(component.getClientId(facesContext) + ":tbody_element"), null);
        this.encodeInnerHtml(facesContext, component);
        writer.endElement("tbody");
    }

    public void encodeInnerHtml(FacesContext facesContext, UIComponent component) throws IOException {
        int last;
        String columnClasses;
        String rowClasses;
        UIData uiData = (UIData)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (component instanceof HtmlDataTable) {
            rowClasses = ((HtmlDataTable)component).getRowClasses();
            columnClasses = ((HtmlDataTable)component).getColumnClasses();
        } else {
            rowClasses = (String)component.getAttributes().get("rowClasses");
            columnClasses = (String)component.getAttributes().get("columnClasses");
        }
        StyleIterator rowStyleIterator = new StyleIterator(rowClasses);
        StyleIterator columnStyleIterator = new StyleIterator(columnClasses);
        int first = uiData.getFirst();
        int rows = uiData.getRows();
        int rowCount = uiData.getRowCount();
        if (rows <= 0) {
            rows = rowCount - first;
        }
        if ((last = first + rows) > rowCount) {
            last = rowCount;
        }
        for (int i = first; i < last; ++i) {
            uiData.setRowIndex(i);
            if (!uiData.isRowAvailable()) {
                log.error((Object)("Row is not available. Rowindex = " + i));
                return;
            }
            columnStyleIterator.reset();
            this.beforeRow(facesContext, uiData);
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            this.renderRowStart(facesContext, writer, uiData, rowStyleIterator);
            List children = component.getChildren();
            int size = component.getChildCount();
            for (int j = 0; j < size; ++j) {
                UIComponent child = (UIComponent)children.get(j);
                if (!child.isRendered()) continue;
                this.encodeColumnChild(facesContext, writer, uiData, child, columnStyleIterator);
            }
            this.renderRowEnd(facesContext, writer, uiData);
            this.afterRow(facesContext, uiData);
        }
    }

    protected void encodeColumnChild(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, Iterator columnStyleIterator) throws IOException {
        if (component instanceof UIColumn) {
            this.renderColumnBody(facesContext, writer, uiData, component, columnStyleIterator);
        }
    }

    protected void renderColumnBody(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, Iterator columnStyleIterator) throws IOException {
        writer.startElement("td", (UIComponent)uiData);
        if (columnStyleIterator.hasNext()) {
            writer.writeAttribute("class", columnStyleIterator.next(), null);
        }
        RendererUtils.renderChild(facesContext, component);
        writer.endElement("td");
    }

    protected void renderRowStart(FacesContext facesContext, ResponseWriter writer, UIData uiData, Iterator rowStyleIterator) throws IOException {
        writer.startElement("tr", (UIComponent)uiData);
        String rowId = (String)uiData.getAttributes().get("org.apache.myfaces.dataTable.ROW_ID");
        if (rowStyleIterator.hasNext()) {
            writer.writeAttribute("class", rowStyleIterator.next(), null);
        }
        if (rowId != null) {
            writer.writeAttribute("id", (Object)rowId, null);
        }
    }

    protected void renderRowEnd(FacesContext facesContext, ResponseWriter writer, UIData uiData) throws IOException {
        writer.endElement("tr");
    }

    protected void beforeTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void beforeRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlTableRendererBase.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("table");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        this.afterTable(facesContext, (UIData)uiComponent);
    }

    protected void renderFacet(FacesContext facesContext, ResponseWriter writer, UIComponent component, boolean header) throws IOException {
        UIComponent facet;
        int colspan = 0;
        boolean hasColumnFacet = false;
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent uiComponent = (UIComponent)it.next();
            if (!uiComponent.isRendered()) continue;
            colspan += this.determineChildColSpan(uiComponent);
            if (hasColumnFacet) continue;
            hasColumnFacet = this.hasFacet(header, uiComponent);
        }
        UIComponent uIComponent = facet = header ? (UIComponent)component.getFacets().get(HEADER_FACET_NAME) : (UIComponent)component.getFacets().get(FOOTER_FACET_NAME);
        if (facet != null || hasColumnFacet) {
            String elemName = header ? "thead" : "tfoot";
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement(elemName, component);
            if (header) {
                String headerStyleClass = HtmlTableRendererBase.getHeaderClass(component);
                if (facet != null) {
                    this.renderTableHeaderRow(facesContext, writer, component, facet, headerStyleClass, colspan);
                }
                if (hasColumnFacet) {
                    this.renderColumnHeaderRow(facesContext, writer, component, headerStyleClass);
                }
            } else {
                String footerStyleClass = HtmlTableRendererBase.getFooterClass(component);
                if (hasColumnFacet) {
                    this.renderColumnFooterRow(facesContext, writer, component, footerStyleClass);
                }
                if (facet != null) {
                    this.renderTableFooterRow(facesContext, writer, component, facet, footerStyleClass, colspan);
                }
            }
            writer.endElement(elemName);
        }
    }

    protected boolean hasFacet(boolean header, UIComponent uiComponent) {
        if (uiComponent instanceof UIColumn) {
            UIColumn uiColumn = (UIColumn)uiComponent;
            return header ? uiColumn.getHeader() != null : uiColumn.getFooter() != null;
        }
        return false;
    }

    protected int determineChildColSpan(UIComponent uiComponent) {
        if (uiComponent instanceof UIColumn) {
            return 1;
        }
        return 0;
    }

    protected void renderTableHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent headerFacet, String headerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, component, headerFacet, headerStyleClass, "th", colspan);
    }

    protected void renderTableFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent footerFacet, String footerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, component, footerFacet, footerStyleClass, "td", colspan);
    }

    protected void renderColumnHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String headerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, headerStyleClass, true);
    }

    protected void renderColumnFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String footerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, footerStyleClass, false);
    }

    private void renderTableHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent facet, String styleClass, String colElementName, int colspan) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", component);
        writer.startElement(colElementName, component);
        if (colElementName.equals("th")) {
            writer.writeAttribute("scope", (Object)"colgroup", null);
        }
        writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement(colElementName);
        writer.endElement("tr");
    }

    private void renderColumnHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String styleClass, boolean header) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", component);
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent uiComponent = (UIComponent)it.next();
            if (!uiComponent.isRendered()) continue;
            this.renderColumnChildHeaderOrFooterRow(facesContext, writer, uiComponent, styleClass, header);
        }
        writer.endElement("tr");
    }

    protected void renderColumnChildHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String styleClass, boolean header) throws IOException {
        if (uiComponent instanceof UIColumn) {
            if (header) {
                this.renderColumnHeaderCell(facesContext, writer, uiComponent, ((UIColumn)uiComponent).getHeader(), styleClass, 0);
            } else {
                this.renderColumnFooterCell(facesContext, writer, uiComponent, ((UIColumn)uiComponent).getFooter(), styleClass, 0);
            }
        }
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String headerStyleClass, int colspan) throws IOException {
        this.renderColumnHeaderCell(facesContext, writer, (UIComponent)uiColumn, uiColumn.getHeader(), headerStyleClass, colspan);
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String headerStyleClass, int colspan) throws IOException {
        writer.startElement("th", uiComponent);
        if (colspan > 1) {
            writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
        }
        if (headerStyleClass != null) {
            writer.writeAttribute("class", (Object)headerStyleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement("th");
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String footerStyleClass, int colspan) throws IOException {
        this.renderColumnFooterCell(facesContext, writer, (UIComponent)uiColumn, uiColumn.getFooter(), footerStyleClass, colspan);
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String footerStyleClass, int colspan) throws IOException {
        writer.startElement("td", uiComponent);
        if (colspan > 1) {
            writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
        }
        if (footerStyleClass != null) {
            writer.writeAttribute("class", (Object)footerStyleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement("td");
    }

    protected static String getHeaderClass(UIComponent component) {
        if (component instanceof HtmlDataTable) {
            return ((HtmlDataTable)component).getHeaderClass();
        }
        return (String)component.getAttributes().get("headerClass");
    }

    protected static String getFooterClass(UIComponent component) {
        if (component instanceof HtmlDataTable) {
            return ((HtmlDataTable)component).getFooterClass();
        }
        return (String)component.getAttributes().get("footerClass");
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class StyleIterator
    implements Iterator {
        private String[] _style;
        private int _idx = 0;

        StyleIterator(String styles) {
            this._style = styles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(styles, ','));
        }

        public boolean hasNext() {
            return this._style.length > 0;
        }

        public Object next() {
            if (this.hasNext()) {
                return this._style[this._idx++ % this._style.length];
            }
            throw new NoSuchElementException("no style defined");
        }

        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        public void reset() {
            this._idx = 0;
        }
    }
}

