/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.portal.security;

import java.util.ArrayList;

import org.apache.cocoon.auth.StandardUser;

/**
 * @version $Id: PortalUser.java 433543 2006-08-22 06:22:54Z crossley $
 */
public class PortalUser extends StandardUser {

	private int uid;
	private String lastname;
	private String firstname;
	private String password;
	
	public PortalUser(String uid) {
		super(uid);
		this.roles = new ArrayList();
	}

	public String getFirstname() {
		return firstname;
	}

	public void setFirstname(String firstname) {
		this.firstname = firstname;
	}

	public String getLastname() {
		return lastname;
	}

	public void setLastname(String lastname) {
		this.lastname = lastname;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getRole() {
		return (String) roles.get(0);
	}

	public void setRole(String role) {
		this.roles.clear();
		this.roles.add(role);
	}

	public int getUid() {
		return uid;
	}

	public void setUid(int uid) {
		this.uid = uid;
	}

	public String getUsername() {
		return id;
	}

	public void setUsername(String username) {
		this.id = username;
	}

}
