# $Id: Document.pm 38127 2012-11-05 14:29:46Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/WS/Responder/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::Responder::Document;

use Aselect::Util;

use Xyzzy::Document -self;

sub response {
	my $req = $self->req;
	my $id = $req->server_id;
	my $response = $req->response;

	return new Xyzzy::Response(
		mimetype => 'application/x-www-form-urlencoded',
		content => aselect_join(%$response, 'a-select-server' => $id),
	);
}
