<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/> 

	<xsl:param name="script_url"/>

	<xsl:template match="/">
		<xsl:variable name="title">
			<xsl:apply-templates mode="title"/>
		</xsl:variable>
		<html xml:lang="en"><head>
			<base href="{$script_url}/"/>
			<title><xsl:value-of select="string($title)"/> – A-Select SSO</title>
		</head><body>
			<h1><xsl:value-of select="$title"/></h1>
			<xsl:apply-templates/>
		</body></html>
	</xsl:template>

	<!-- prevent extraneous text from showing up -->
	<xsl:template match="text()"/>
</xsl:stylesheet>
