# $Id: Document.pm 42299 2014-09-26 14:30:54Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Password/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password::Document;

use Aselect::UI::Login::Document -self;

use constant rootname => 'password';

sub build {
	my $req = $self->req;

	my $root = $self->documentElement;
	$root->appendChild($self->construct(lt => scalar $req->new_session->create_lt));

	if(my $username = $req->username) {
		$root->appendChild($self->construct(username => $username));
	}

	if(my $message = $req->message) {
		$root->appendChild($self->construct(message => $message));
	}
}
