# $Id: Request.pm 47629 2018-06-25 14:25:42Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Static/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Static::Request;

use Xyzzy::Static;
use Aselect::UI::Error::HTTP;

use Aselect::Request -self;
use Xyzzy::Static::Request -mixin;

sub error {
	my $doc = new Aselect::UI::Error::HTTP(req => $self, number => shift);
	return $doc->response;
}

sub path_components {
	my $path = super;
	my $lang = $self->lang
		or return $path;
	$path = ['index'] unless @$path;
	return [$lang, @$path];
}
