#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

BEGIN { use_ok('Aselect::Util', qw(aselect_url)) or BAIL_OUT('need Aselect::Util to run') }

foreach my $t (
	['http://example.com', 'http://example.com?foo=bar'],
	['http://example.com?lol=wut', 'http://example.com?lol=wut&foo=bar'],
	['http://example.com#herpderp?', 'http://example.com?foo=bar#herpderp?'],
	['http://example.com?lol=wut#herpderp?', 'http://example.com?lol=wut&foo=bar#herpderp?'],
	['http://example.com:1234', 'http://example.com:1234?foo=bar'],
	['http://example.com:1234?lol=wut', 'http://example.com:1234?lol=wut&foo=bar'],
	['http://example.com:1234#herpderp?', 'http://example.com:1234?foo=bar#herpderp?'],
	['http://example.com:1234?lol=wut#herpderp?', 'http://example.com:1234?lol=wut&foo=bar#herpderp?'],
) {
	my ($url, $res) = @$t;
	is(aselect_url($url), $url, "do not extend url");
	is(aselect_url($url, foo => 'bar'), $res, "extend url");
}

done_testing();
