#! /usr/bin/env perl

use strict;
use warnings FATAL => 'all';

use Module::Build;
use File::Find;

do {
    open my $fh, '>', 'MANIFEST'
        or die "open(MANIFEST): $!\n";
    find({ wanted => sub { -f or return; print $fh "$_\n" or die "write(MANIFEST): $!\n" }, no_chdir => 1, follow => 0}, 'lib');
    close $fh or die "close(MANIFEST): $!\n";
};

my $build = new Module::Build(
	dist_name => 'displayentry-perl',
	dist_version => '2.0',
	dist_abstract => 'Ldap Browser for Tilburg University',
	dist_author => 'Anton Sluijtman <anton@uvt.nl>',
	module_name => 'Displayentry',
	license => 'perl',
	script_files => [],
	create_makefile_pl => 'small',
);
$build->create_build_script;
